/*
  Thingy Example - Basic

  This is example of the basic use case - connects an axon to Thingy system

  Copyright (c) 2017 Thingy.IO

*/

#include <Thingy.h>

Thingy::Axon axon;

// notification handler for axon change
void axon_changed(const Thingy::Axon& sender, const String& topic, const String& payload, const MQTT::Publish& pub)
{
	// TO DO
}

// notification handler for axon change
void stream_changed(const Thingy::Stream& sender, const String& value)
{
	// TO DO
}

void setup() {
	// setup console
	Serial.begin(115200);
	delay(10);

	Serial << endl << endl  << F("Thingy.Basic") << " - " << __DATE__ << " " << __TIME__ << endl << "#" << endl << endl;

  // Setup axon
	axon.setup();
	//axon.set_uid("<UID>"").set_sid("<SID>").settings_save();

  // Initializy axon thingy connection
	if (!axon.begin())
	{
		Serial << F("Fatal error") << endl << endl << endl;
		return;
	}

	// hooking up notification handler for axon
	axon.setHandle(axon_changed);

	// hooking up notification handler for stream
	axon["<stream name>"].setHandle(stream_changed);

	// hooking up notification handler for stream (delegate)
	axon["<stream uid>"].setHandle([](const Thingy::Stream& sender, const String& value){
		// TO DO
	});

}

long millis_15 = millis();
long millis_60 = millis();

void loop() {
	// loop invoke on thingy
	axon.loop();

	// every 15s - diagnostisc
	if ((millis_15 != 0) && (millis() - millis_15 < 15000)) return;
	millis_15 = millis();
	Serial << F("Thingy [") << (axon.connected() ? F("OnLine"):F("OffLine")) << F("] - # 15s @ ") << axon.ticks() << endl;
	//

	if (!axon.connected()) return;

	// only if axon is online
	// TO DO

	// every 60 seconds - diagnostisc
	if ((millis_60!= 0) && (millis() - millis_60 < 60000)) return;
	millis_60 = millis();
	Serial << F("Thingy - # 60s @ ") << axon.ticks() << endl;
	//

	// write some value to the axon with QoS 0 and not retained
	axon["<stream uid>"].put("<value>");

	// write some value to the axon with QoS 1 and retained
	axon["<stream uid>"].put("<value>", 1, true);

	// write some value to the axon with QoS 2 and not retained
	axon["<stream name>"].put("<value>", 2, false);

}
