/*
	Thingy Axon library

	BluetoothClient is part of Thingy library that handles communication to BLE module

	Copyright (c) 2017 Thingy.IO
*/

#ifndef BluetoothClient_h
#define BluetoothClient_h

#include <Arduino.h>
#include <ArduinoJson.h>
#include <SoftwareSerial.h>

extern "C" {
#include "user_interface.h"
}

#define MAX_BEACONS 10
//TODO: calculate the optimal size of string for max beacons

#define RESPONSE_LEN 70 //defined in HM-11
#define DELETE_DEADLINE 2*60*1000 //2 mins.
#define BUFFER_SIZE 64

class BluetoothClient
{

struct Beacon{
	char data[RESPONSE_LEN];
	long advertisementsCnt;
	long lastActive;
};

public:
	BluetoothClient(int baudRatei, long loopLengthi);
	Beacon BeaconTable[MAX_BEACONS];
	int BeaconNumber = 0;
	bool setup();
	bool readCommand();
	void jsonTable(String* json);
	bool startBeacon(char* major, char* minor);
	void loop();

private:
	SoftwareSerial btSer;

	bool writetoBT = true;

	bool readBytesBT(char *buff, int bytesNo, long timeout);
	void writeBytesBT(char const *buff);
	bool isBTresponse(char const *sendbuff, char const *buff, long timeout);
	void readOneBeacon();
	void deleteOldBeacons();

	char BeaconResponse[8];// = "OK+DISC:";
	int checkCnt = 0;
	long loopLength;
	long oldmillis = 0;
};

#endif
