/*
  Thingy Example - WiFi Acccess Points List

  This example lists the visible WiFi endpoints and publishes it

  Copyright (c) 2017 Thingy.IO
*/

#include <Thingy.h>

Thingy::Axon axon;
Thingy::Stream *stream_WiFi;

void setup()
{
	// Setup console
	Serial.begin(115200);
	delay(10);
	Serial << endl << endl  << F("Thingy.WiFi") << " - " << __DATE__ << " " << __TIME__ << endl << "#" << endl << endl;

	// Setup axon
	axon.setup();

	// Initializy axon thingy connection
	if (!axon.begin())
	{
		Serial << F("Fatal error") << endl << endl << endl;
		return;
	}

	// mapping streams
	stream_WiFi = &axon["WiFi"];
}

long millis_15 = millis();
long millis_60 = millis();

void loop()
{
	axon.loop();

  // every 15s
	if ((millis_15 != 0) && (millis() - millis_15 < 15000)) return;
	millis_15 = millis();
	Serial << F("Thingy [") << (axon.connected() ? F("OnLine"):F("OffLine")) << F("] - # 15s @ ") << axon.ticks() << endl;
	//

	if (!axon.connected()) return;

  // every 60 seconds
	if ((millis_60!= 0) && (millis() - millis_60 < 60000)) return;
	millis_60 = millis();
	Serial << F("Thingy - # 60s @ ") << axon.ticks() << endl;
	//

  Serial << F("Thingy.WiFi - Scanning WiFi");
	String wifiList;
	axon.scan_wifi_networks(wifiList);
  Serial << F("- Done") << endl;
	stream_WiFi->put(wifiList);

}
