/*
  Thingy Example - Bluetooth Acccess Points List

  This example lists the visible Bluetooth endpoints and publishes it

  Copyright (c) 2017 Thingy.IO
*/

#include <Thingy.h>
#include <BluetoothClient.h>

Thingy::Axon axon;

BluetoothClient btclient(9600, 10000);

void setup() {
	// Reset switch
	pinMode(5, INPUT);
	pinMode(0, INPUT);

	// Green LED
	pinMode(4, OUTPUT);
	digitalWrite(4, HIGH);

	// Red LED
	pinMode(16, OUTPUT);
	digitalWrite(16, HIGH);

	// Setup console
	Serial.begin(115200);
	delay(10);
	Serial << endl << endl  << F("Thingy.Bluetooth") << " - " << __DATE__ << " " << __TIME__ << endl << "#" << endl << endl;

	// Setup axon
	axon.setup();

	// Initializy axon thingy connection
	if (!axon.begin())
	{
		//Serial << F("Fatal error") << endl << endl << endl;
		return;
	}

	btclient.setup();
	axon.cursor();
}


long millis_15 = millis();
long millis_60 = millis();

long millis_cnt = millis();

#define LOOP 10 //report time in seconds
bool sendstuff = false;
long diodeCnt = millis();

void loop() {

	// loop invoke on thingy
	if (millis() - diodeCnt > 1000)
	{
		digitalWrite(16, !digitalRead(16));
		diodeCnt = millis();
	}

	axon.setupLoop();
	if (axon.setupMode) return; //if setup mode, don't do anything and wait for restart

	axon.consoleLoop();
	axon.loop();
	if (!axon.connected())
		return;

	btclient.loop();

	// every LOOP seconds
	if (millis() - millis_cnt < LOOP*1000)
	{
	 // system_soft_wdt_restart();
	  return;
	}
	millis_cnt = millis();

	btclient.readCommand();

	String jsonSpace;
	jsonSpace.reserve(2000);

	system_soft_wdt_feed();

	// only if thingy is online
	if (axon.connected())
	{
		system_soft_wdt_feed();

		//axon.publish(MQTT::Publish(axon.mqtt_topic + "uptime", Thingy::Helper::uptime_formatted()).set_qos(1));
		system_soft_wdt_feed();

		btclient.jsonTable(&jsonSpace);

		axon["Bluetooth"].put(jsonSpace);

		axon.cursor();
	}
}
